/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.network.fabric;

import com.talhanation.smallships.network.ModPacket;
import com.talhanation.smallships.network.ModPackets;
import com.talhanation.smallships.network.fabric.FabricPacket;
import com.talhanation.smallships.network.fabric.ServerboundOpenShipScreenFabricPacket;
import com.talhanation.smallships.network.fabric.ServerboundShootShipCannonFabricPacket;
import com.talhanation.smallships.network.fabric.ServerboundToggleShipSailFabricPacket;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ModPacketsImpl {
    private static final Map<String, ModPackets.SendablePacket<FabricPacket>> entries = new HashMap<String, ModPackets.SendablePacket<FabricPacket>>();

    public static ModPackets.SendablePacket<FabricPacket> getPacket(String id) {
        return entries.get(id);
    }

    public static void registerPackets() {
        ModPacketsImpl.registerServerPacket(ModPackets.id("server_open_ship_screen"), (server, player, handler, buf, responseSender) -> {
            ServerboundOpenShipScreenFabricPacket packet = new ServerboundOpenShipScreenFabricPacket(buf);
            packet.receive(server, player, handler, buf, responseSender);
        });
        ModPacketsImpl.registerServerPacket(ModPackets.id("server_toggle_ship_sail"), (server, player, handler, buf, responseSender) -> {
            ServerboundToggleShipSailFabricPacket packet = new ServerboundToggleShipSailFabricPacket(buf);
            packet.receive(server, player, handler, buf, responseSender);
        });
        ModPacketsImpl.registerServerPacket(ModPackets.id("server_shoot_ship_cannon"), (server, player, handler, buf, responseSender) -> {
            ServerboundShootShipCannonFabricPacket packet = new ServerboundShootShipCannonFabricPacket(buf);
            packet.receive(server, player, handler, buf, responseSender);
        });
    }

    private static void registerServerPacket(class_2960 id, ServerPlayNetworking.PlayChannelHandler channelHandler) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)id, (ServerPlayNetworking.PlayChannelHandler)channelHandler);
    }

    private static void registerClientPacket(class_2960 id, ClientPlayNetworking.PlayChannelHandler channelHandler) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)id, (ClientPlayNetworking.PlayChannelHandler)channelHandler);
    }

    public static <T extends ModPacket> void serverSendPacket(class_3222 player, T packetIn) {
        FabricPacket packet = (FabricPacket)packetIn;
        class_2540 buf = PacketByteBufs.create();
        packet.toBytes(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getId(), (class_2540)buf);
    }

    public static <T extends ModPacket> void clientSendPacket(class_1657 player, T packetIn) {
        FabricPacket packet = (FabricPacket)packetIn;
        class_2540 buf = PacketByteBufs.create();
        packet.toBytes(buf);
        ClientPlayNetworking.send((class_2960)packet.getId(), (class_2540)buf);
    }

    static {
        entries.put("server_open_ship_screen", params -> new ServerboundOpenShipScreenFabricPacket((ContainerShip)((Object)((Object)params[0])), (Integer)params[1]));
        entries.put("server_toggle_ship_sail", params -> new ServerboundToggleShipSailFabricPacket());
        entries.put("server_shoot_ship_cannon", params -> new ServerboundShootShipCannonFabricPacket());
    }
}

